﻿//////////////////////////////////////////////
// AtmosphereProgramTracker.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkAstraeus
#include "../../Utils/ProgramTracker.h"

#include "AtmosphereEffectInfo.h"

/// Internals --------------------------------

namespace nkAstraeus
{
	struct AtmosphereProgramIdGenerator
	{
		static unsigned long long generate (const AtmosphereEffectInfo& info) ;
	} ;

	struct AtmosphereProgramNameGenerator
	{
		constexpr static const char* name = "NILKINS_ATMOSPHERE_PROGRAM_" ;
	} ;
}

/// Class ------------------------------------

namespace nkAstraeus
{
	class AtmosphereProgramTracker final : public ProgramTracker<AtmosphereEffectInfo, AtmosphereProgramIdGenerator, AtmosphereProgramNameGenerator>
	{
		public :

			// Functions
			// Constructor, destructor
			AtmosphereProgramTracker (nkGraphics::System* system) noexcept ;
			virtual ~AtmosphereProgramTracker () ;
	} ;
}